
// Neurosis Engine - LP23.com
// Copyright  Luigi Pino. All rights reserved.

/***************************************************************************/

#ifndef _NEUROSIS_ENGINE_NETWORK_H_
#define _NEUROSIS_ENGINE_NETWORK_H_

/***************************************************************************/

//------------------------------------------------
#define NETWORK_BUFFER						4096
//------------------------------------------------

/***************************************************************************/

//! Note: Buffer automatically gets sent if over bufferSize value.
//!	Note: bufferSize should be made large enough to store any data sent/recv.
class CNeurosisNetwork {
	public:
		CNeurosisNetwork(int maxConnections, int bufferSize);
		//! Constructor/Deconstructor
		~CNeurosisNetwork();

		//! Retrieve buffer data
		char*	Buffer_Retrieve(int iConnection);
		//! Store buffer data
		void	Buffer_Store(int iConnection, char *data);
		//! Search for incoming connections
		bool	Check_For_Clients(int iConnection);
		//! Attempt to close socket
		int		Close_Socket(int iConnection);
		//! Open connection to server
		bool	Connect_To_Server(int iConnection, char *ip, int portNumber, bool isIPAddress);
		//! Returns socket used
		int		Get_Socket(int iConnection);
		//! Initialize server connection
		bool	Initialize_Server(int iConnection, int portNumber);
		//! Returns connection availability
		bool	In_Use(int iConnection);
		//! Receive data from connection
		int		Recv(int iConnection, char *data, bool blocking);
		//! Receive file from connection
		bool	Recv_File(int iConnection, char *filename);
		//! Receive string from connection (to buffer)
		void	Recv_String(int iConnection);
		//! Send data to buffer - sendImmediately will also send buffer
		int		Send(int iConnection, char *data, int dataSize, bool sendImmediately);
		//! Send file to connection
		bool	Send_File(int iConnection, char *filename);
		//! Send string to connection (from buffer)
		void	Send_String(int iConnection);

	private:
		struct CNetworkData {
			char					*pBuffer;
			bool					mInUse;
			sockaddr_in		mAddress;
			unsigned int	mSocket;
		};

		CNetworkData	*pNetwork;
		int						mBufferSize;
		int						mMaxConnections;
};

/***************************************************************************/
#endif